/*
	File:		LiveFeedbackDialog.cp

	Contains:	Demonstration of live feedback.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

//
//	This file implements a dialog demonstrating live feedback with sliders
//	and scroll bars. In this case, we have one of each control. They are
//	connected to a text field showing the current value as well as each
//	other, i.e. moving one automatically adjusts the other.
//

#include <TextUtils.h>
#include "LiveFeedbackDialog.h"
#include "Appearance.h"
#include "AppearanceHelpers.h"

enum {
	kScrollBar			= 1,
	kSlider				= 2,
	kStaticText			= 4
};

ControlActionUPP	LiveFeedbackDialog::fProc = NewControlActionProc( LiveFeedbackDialog::LiveActionProc );

LiveFeedbackDialog::LiveFeedbackDialog() : BaseDialog( 1004 )
{
	if ( fWindow )
	{
			// These controls have been created with a live scrolling
			// variant. We'll set the action proc using SetControlAction.
			
		GetDialogItemAsControl( fWindow, kScrollBar, &fScrollBar );
		SetControlReference( fScrollBar, (long)this );
		GetDialogItemAsControl( fWindow, kSlider, &fSlider );
		SetControlReference( fSlider, (long)this );

		SetControlAction( fScrollBar, fProc );
		SetControlAction( fSlider, fProc );
	}
}

LiveFeedbackDialog::~LiveFeedbackDialog()
{
}

//
//	 LiveActionProc
//
//	Here's our ControlActionUPP that also handles the indicator. At last, we can
//	actually use the same function callback for both! There is a difference when
//	called with the indicator as the part, as opposed to the up/down arrows, etc.
//	If we are called because the indicator is being dragged, the value has already
//	been calculated for us. If we are being called because the scroll bar arrows
//	have been pressed, then we must determine how much to scroll by and set the
//	scroll bar value accordingly. This allows us to have control over the amount
//	that arrows scroll by. We can allow the indicator dragging to determine the
//	value because the indicator always shows a percentage.
//
pascal void
LiveFeedbackDialog::LiveActionProc( ControlHandle control, SInt16 part )
{
	ControlHandle		text;
	Str255				valueText;
	LiveFeedbackDialog*	dialog;
	SInt16				startValue;
	SInt16				delta;
	
	startValue = GetControlValue( control );
	
	delta = 0;
	
	switch ( part )
	{
		case kControlUpButtonPart:
			if ( startValue > GetControlMinimum( control ) )
				delta = -1;
			break;
		
		case kControlDownButtonPart:
			if ( startValue < GetControlMaximum( control ) )
				delta = 1;
			break;
		
		case kControlPageUpPart:
			if ( startValue > GetControlMinimum( control ) )
				delta = -10;
			break;
		
		case kControlPageDownPart:
			if ( startValue < GetControlMaximum( control ) )
				delta = 10;
			break;
	}
	if ( delta )
		SetControlValue( control, startValue + delta );

	if ( part != kControlIndicatorPart && delta == 0 )
		return;

	dialog = (LiveFeedbackDialog*)GetControlReference( control );

	GetDialogItemAsControl( (**control).contrlOwner, kStaticText, &text );
	NumToString( GetControlValue( control ), valueText );
	SetStaticTextText( text, valueText, true );

	if ( control == dialog->fScrollBar )
		SetControlValue( dialog->fSlider, GetControlValue( control ) );
	else
		SetControlValue( dialog->fScrollBar, GetControlValue( control ) );
}
